def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define positions based on the retrieved information (example placeholders)
        gripper_position = 'position1'  # Example position for the gripper
        drawer_position = positions['drawer']
        
        # Example Task Plan
        # Step 1: Move to the drawer
        print(f"[Task] Moving to the drawer at: {drawer_position}")
        obs, reward, done = move(env, 'initial_position', drawer_position)

        if done:
            print("[Task] Task ended after moving to the drawer!")
            return
        
        # Step 2: Pick the drawer handle
        print("[Task] Picking the drawer handle")
        obs, reward, done = pick(env, 'drawer_handle', drawer_position, 'gripper')

        if done:
            print("[Task] Task ended after picking the drawer handle!")
            return
        
        # Step 3: Pull the drawer open
        print("[Task] Pulling the drawer")
        obs, reward, done = pull(env, 'gripper', 'drawer', drawer_position)

        if done:
            print("[Task] Task ended after pulling the drawer!")
            return
        
        # Step 4: Rotate the gripper to a specific angle
        print("[Task] Rotating the gripper to a target angle")
        target_angle = 'target_angle'  # Define the target angle for rotation
        obs, reward, done = rotate(env, task, target_angle)

        if done:
            print("[Task] Task ended after rotating the gripper!")
            return

        # Step 5: Place object into the drawer (assuming the object was held)
        print("[Task] Placing object into the drawer")
        obs, reward, done = place(env, 'object_to_place', drawer_position)

        if done:
            print("[Task] Task ended after placing the object into the drawer!")
            return

        print("[Task] Completed all steps successfully.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()