def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example object positions based on the initial details.
        # Assuming we are dealing with a drawer and a gripper in the simulation.
        drawer_position = positions['drawer']
        gripper_position = positions['gripper']

        # Initialize any necessary variables for the task
        current_gripper_state = None
        
        # Step 1: Move to the drawer location
        print(f"[Task] Moving to drawer position: {drawer_position}")
        obs, reward, done = move(env, 'current_location', drawer_position)
        if done: 
            print("[Task] Task ended after moving to the drawer!")
            return

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer")
        obs, reward, done = pick(env, 'drawer', drawer_position, 'gripper')
        if done: 
            print("[Task] Task ended after picking the drawer!")
            return
        
        # Step 3: Open the drawer
        print("[Task] Rotating gripper to open drawer")
        angle = 'ninety_deg'
        obs, reward, done = rotate(env, task, angle)
        if done: 
            print("[Task] Task ended after rotating!")
            return
        
        print("[Task] Pulling the drawer open")
        obs, reward, done = pull(env, 'gripper', 'drawer')
        if done: 
            print("[Task] Task ended after pulling drawer!")
            return
        
        # Step 4: Place the object back into the drawer
        print("[Task] Placing object back into drawer")
        obs, reward, done = place(env, 'object_to_place', drawer_position)
        if done: 
            print("[Task] Task ended after placing object back!")
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()