def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming object positions are available as keys
        # Let's assume we have a drawer and a ball in the environment with their respective positions
        drawer_pos = positions['drawer1']
        ball_pos = positions['ball1']
        gripper_pos = positions['gripper']

        # Step 1: Move to ball position
        print("[Task] Moving to ball position:", ball_pos)
        obs, reward, done = move(env, gripper_pos, ball_pos)

        if done:
            print("[Task] Task ended after moving to ball position!")
            return

        # Step 2: Pick the ball
        print("[Task] Picking the ball.")
        obs, reward, done = pick(env, 'ball1', 'room1', 'gripper')

        if done:
            print("[Task] Task ended after picking the ball!")
            return

        # Step 3: Move to the drawer position
        print("[Task] Moving to drawer position:", drawer_pos)
        obs, reward, done = move(env, ball_pos, drawer_pos)

        if done:
            print("[Task] Task ended after moving to drawer position!")
            return

        # Step 4: Place the ball into the drawer
        print("[Task] Placing the ball into the drawer.")
        obs, reward, done = place(env, 'ball1', 'drawer1')

        if done:
            print("[Task] Task ended after placing the ball!")
            return

        # Additional Steps if needed...
        # Example: Open the drawer if closed (optional step)
        print("[Task] Ensure drawer is opened.")
        if not obs['is_open']:
            obs, reward, done = pull(env, 'gripper', 'drawer1')
        
        if done:
            print("[Task] Task ended after opening the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()