def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Retrieve specific object positions
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        table_pos = positions['table']

        # Step 1: Approach and pick tomato1
        print("[Task] Approaching tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, task, obs.robot_position, table_pos)
        if done:
            print("[Task] Task ended while moving to tomato1!")
            return
        
        print("[Task] Picking up tomato1.")
        obs, reward, done = pick(env, 'tomato1', table_pos, obs.gripper)
        if done:
            print("[Task] Task ended after picking tomato1!")
            return

        # Step 2: Place tomato1 at a designated location (e.g., a shelf)
        designated_place_pos = positions['shelf']
        print("[Task] Placing tomato1 at:", designated_place_pos)
        obs, reward, done = place(env, 'tomato1', designated_place_pos)
        if done:
            print("[Task] Task ended after placing tomato1!")
            return
        
        # Step 3: Approach and pick tomato2
        print("[Task] Approaching tomato2 at:", tomato2_pos)
        obs, reward, done = move(env, task, obs.robot_position, table_pos)
        if done:
            print("[Task] Task ended while moving to tomato2!")
            return
        
        print("[Task] Picking up tomato2.")
        obs, reward, done = pick(env, 'tomato2', table_pos, obs.gripper)
        if done:
            print("[Task] Task ended after picking tomato2!")
            return

        # Step 4: Place tomato2 at the designated location (e.g., a shelf)
        print("[Task] Placing tomato2 at:", designated_place_pos)
        obs, reward, done = place(env, 'tomato2', designated_place_pos)
        if done:
            print("[Task] Task ended after placing tomato2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()