def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assuming object_1 is the item to pick and place, adjust accordingly
        object_1_pos = positions['object_1']  # Example placeholder for the object's position
        drawer_position = positions['drawer']  # Example placeholder for the drawer's position
        approach_distance = 0.15  # Distance to approach objects

        # 1) Move to object_1
        print(f"[Task] Moving to object_1 at: {object_1_pos}")
        obs, reward, done = move(env, 'current_room', object_1_pos)
        if done:
            print("[Task] Task ended after moving to object_1!")
            return
        
        # 2) Pick object_1
        print("[Task] Picking object_1")
        obs, reward, done = pick(env, 'object_1', 'current_room', 'gripper')
        if done:
            print("[Task] Task ended after picking object_1!")
            return
        
        # 3) Move to the drawer's side position
        print(f"[Task] Moving to the side position of the drawer at: {drawer_position}")
        obs, reward, done = move(env, object_1_pos, drawer_position)
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return
        
        # 4) Place the object in the drawer
        print(f"[Task] Placing object_1 into the drawer")
        obs, reward, done = place(env, 'object_1', 'drawer')
        if done:
            print("[Task] Task ended after placing object_1!")
            return

    finally:
        # Always ensure environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()