def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a drawer and a gripper in the environment
        drawer_position = positions['drawer']
        gripper_position = positions['gripper']
        
        # Step 1: Move to the drawer's side position
        print("[Task] Moving to the drawer's side position.")
        obs, reward, done = move(env, gripper_position, drawer_position)
        if done:
            print("[Task] Task ended after moving to the drawer's side position!")
            return

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, 'drawer', drawer_position, 'gripper')
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Step 3: Pull the drawer
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, 'gripper', 'drawer')
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Step 4: Place the drawer back
        print("[Task] Placing the drawer back.")
        obs, reward, done = place(env, 'drawer', drawer_position)
        if done:
            print("[Task] Task ended after placing the drawer back!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()