def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer to interact with
        gripper = 'gripper1'
        drawer = 'drawer1'
        position1 = positions['position1']  # Replace with actual position key
        position2 = positions['position2']  # Replace with actual position key

        # Step 1: Move to position1
        print("[Task] Moving to position1")
        obs, reward, done = move(env, task, target_pos=position1)
        if done:
            print("[Task] Task ended after moving to position1!")
            return

        # Step 2: Pick the object at position1
        print("[Task] Picking object at position1")
        obs, reward, done = pick(env, 'object1', position1, gripper)
        if done:
            print("[Task] Task ended after picking object at position1!")
            return

        # Step 3: Move to the drawer
        print("[Task] Moving to the drawer")
        obs, reward, done = move(env, task, target_pos=positions[drawer])
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return

        # Step 4: Place the object in the drawer
        print("[Task] Placing object in the drawer")
        obs, reward, done = place(env, 'object1', drawer)
        if done:
            print("[Task] Task ended after placing object in the drawer!")
            return

        # Step 5: Pull the drawer
        print("[Task] Pulling the drawer")
        obs, reward, done = pull(env, gripper, drawer)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()