def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        # Replace these with actual object names from your environment
        object_1_pos = positions['object_1']  # Example object position
        object_2_pos = positions['object_2']  # Example object position
        gripper = 'gripper'  # Assuming a gripper object is available
        initial_pos = 'initial_position'  # Replace with actual initial position

        # Step 1: Move to the initial position
        print("[Task] Moving to initial position.")
        obs, reward, done = move(env, task, target_pos=initial_pos)
        if done:
            print("[Task] Task ended after moving to initial position!")
            return

        # Step 2: Identify the first object
        print("[Task] Moving to object 1 position.")
        obs, reward, done = move(env, task, target_pos=object_1_pos)
        if done:
            print("[Task] Task ended after moving to object 1!")
            return

        # Step 3: Pick the first object
        print("[Task] Picking object 1.")
        obs, reward, done = pick(env, 'object_1', 'location_1', gripper)
        if done:
            print("[Task] Task ended after picking object 1!")
            return

        # Step 4: Move to the second object
        print("[Task] Moving to object 2 position.")
        obs, reward, done = move(env, task, target_pos=object_2_pos)
        if done:
            print("[Task] Task ended after moving to object 2!")
            return

        # Step 5: Place the first object at the second object's location
        print("[Task] Placing object 1 at object 2's location.")
        obs, reward, done = place(env, 'object_1', 'location_2')
        if done:
            print("[Task] Task ended after placing object 1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()