def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example object positions (assuming these are correct)
        drawer_pos = positions['drawer']
        rubbish_pos = positions['rubbish_bin']
        side_pos = positions['drawer_side']
        anchor_pos = positions['drawer_anchor']

        # Step 1: Move to drawer location
        print(f"[Task] Moving to drawer at: {drawer_pos}")
        obs, reward, done = move(env, 'robot', 'Home', drawer_pos)

        # Step 2: Approach the drawer and pick it
        print(f"[Task] Approaching drawer at: {drawer_pos}")
        obs, reward, done = move(env, 'robot', drawer_pos, side_pos)

        print(f"[Task] Picking drawer handle")
        obs, reward, done = pick(env, 'drawer_handle', side_pos, 'gripper')

        # Step 3: Open the drawer
        print(f"[Task] Opening the drawer")
        obs, reward, done = pull(env, 'robot', 'drawer', side_pos)

        # Step 4: Pick up the rubbish from the drawer
        print(f"[Task] Picking rubbish from the drawer")
        obs, reward, done = pick(env, 'rubbish', 'drawer', 'gripper')

        # Step 5: Move to rubbish bin location
        print(f"[Task] Moving to rubbish bin at: {rubbish_pos}")
        obs, reward, done = move(env, 'robot', 'drawer', rubbish_pos)

        # Step 6: Place rubbish in the bin
        print(f"[Task] Placing rubbish in the bin")
        obs, reward, done = place(env, 'rubbish', rubbish_pos)

        if done:
            print("[Task] Task completed successfully!")

    except Exception as e:
        print(f"[Task] An error occurred: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====") 

if __name__ == "__main__":
    run_skeleton_task()