def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Define positions based on the object_positions utility
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']
        drawer_pos = positions['drawer']  # Assuming this refers to where the rubbish will be taken

        # === Robot Actions ===
        
        # 1) Move to the drawer's position
        print("[Task] Moving to the drawer position.")
        obs, reward, done = move(env, "drawer", "nowhere_pos", drawer_pos)
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return
        
        # 2) Open the drawer (Example of using rotate then pull)
        print("[Task] Rotating to open the drawer handle.")
        obs, reward, done = rotate(env, task, target_quat="desired_quat_for_drawer_handle")
        if done:
            print("[Task] Task ended after attempting to rotate for drawer handle!")
            return
        
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, "drawer")
        if done:
            print("[Task] Task ended after opening the drawer!")
            return
        
        # 3) Move to the rubbish position
        print("[Task] Moving to the rubbish position.")
        obs, reward, done = move(env, "rubbish", "drawer", rubbish_pos)
        if done:
            print("[Task] Task ended after moving to the rubbish!")
            return
        
        # 4) Pick up the rubbish
        print("[Task] Picking up the rubbish.")
        obs, reward, done = pick(env, "rubbish", 'drawer')
        if done:
            print("[Task] Task ended after picking up the rubbish!")
            return
        
        # 5) Move to the bin position to place the rubbish
        print("[Task] Moving to the bin position.")
        obs, reward, done = move(env, "bin", "drawer", bin_pos)
        if done:
            print("[Task] Task ended after moving to the bin!")
            return
        
        # 6) Place the rubbish in the bin
        print("[Task] Placing the rubbish in the bin.")
        obs, reward, done = place(env, "rubbish", "bin")
        if done:
            print("[Task] Successfully placed rubbish in the bin!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()