def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example object positions
        bin_pos = positions['bin']
        rubbish_pos = positions['rubbish']
        drawer_pos = positions['drawer']
        gripper_pos = positions['nowhere_pos']  # Starting position for the gripper

        # Move to drawer side position
        print("[Task] Moving to the drawer side position.")
        obs, reward, done = move(env, gripper_pos, drawer_pos)
        if done:
            print("[Task] Task ended after moving to drawer's side!")
            return
        
        # Pick the drawer using the gripper
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, 'bottom', drawer_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the drawer!")
            return
        
        # Open the drawer
        print("[Task] Opening the drawer.")
        obs, reward, done = pull(env, 'gripper', 'bottom', drawer_pos)  # Assuming 'bottom' is the drawer
        if done:
            print("[Task] Task ended after opening the drawer!")
            return
        
        # Place the rubbish inside the opened drawer
        print("[Task] Placing rubbish into the opened drawer.")
        obs, reward, done = place(env, 'rubbish', drawer_pos)
        if done:
            print("[Task] Task ended after placing rubbish!")
            return
        
        # Move to the bin position to dispose off
        print("[Task] Moving to the bin position.")
        obs, reward, done = move(env, drawer_pos, bin_pos)
        if done:
            print("[Task] Task ended after moving to bin!")
            return
        
        # Finally, placing the rubbish in the bin
        print("[Task] Placing rubbish in the bin.")
        obs, reward, done = place(env, 'rubbish', bin_pos)
        if done:
            print("[Task] Task ended after disposing rubbish!")
            return
            
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()