def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Plan Execution
        # Assume the gripper is already initialized, define its id
        gripper = 'gripper_id'  # Replace with the actual ID if necessary
        
        # Step-by-step execution based on the scripted plan

        # 1. Move to the target location
        start_room = 'room_a'  # Replace with actual initial room
        target_room = 'room_b'  # Replace with actual target room
        obs, reward, done = move(env, start_room, target_room)
        if done:
            print("[Task] Ended after moving to the target room!")
            return
        
        # 2. Pick up the object at the target location
        obj_to_pick = 'target_object'  # Replace with actual object name
        obs, reward, done = pick(env, obj_to_pick, target_room, gripper)
        if done:
            print("[Task] Ended after picking the object!")
            return
        
        # 3. Rotate the gripper to prepare for placement
        rotation_target = 'desired_rotation'  # Define the desired quaternion rotation
        obs, reward, done = rotate(env, task, rotation_target)
        if done:
            print("[Task] Ended after rotating the gripper!")
            return
        
        # 4. Place the object in a new location
        placement_room = 'room_c'  # Replace with the room where the object will be placed
        obs, reward, done = place(env, obj_to_pick, placement_room)
        if done:
            print("[Task] Ended after placing the object!")
            return
        
        # Additional actions can be added here as needed
        # Example: Pulling a drawer if necessary
        drawer_obj = 'drawer_id'  # Replace with actual drawer object ID
        obs, reward, done = pull(env, drawer_obj)
        if done:
            print("[Task] Ended after pulling the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()