def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the available positions from the environment
        drawer_pos = positions['drawer']
        object_pos = positions['object']  # Example object key
        gripper_pos = positions['gripper']

        # 1. Move to the drawer
        print("[Task] Moving to drawer position:", drawer_pos)
        obs, reward, done = move(env, gripper_pos, drawer_pos)
        if done:
            print("[Task] Task ended after moving to drawer!")
            return

        # 2. Pick the drawer
        print("[Task] Picking drawer at position:", drawer_pos)
        obs, reward, done = pick(env, 'drawer', drawer_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking drawer!")
            return
        
        # 3. Pull the drawer
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, 'drawer', drawer_pos)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return
        
        # 4. Move to the side position of the drawer (if needed)
        side_pos = positions['side']  # Example side position for moving
        print("[Task] Moving to side position:", side_pos)
        obs, reward, done = move(env, drawer_pos, side_pos)
        if done:
            print("[Task] Task ended after moving to side position!")
            return
        
        # 5. Place the picked object into the drawer
        print("[Task] Placing object in the drawer.")
        obs, reward, done = place(env, 'object', drawer_pos)
        if done:
            print("[Task] Task ended after placing object in drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()