def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve Object Positions
        positions = get_object_positions()

        # Assuming drawer, rubbish, and other pertinent objects exist in positions
        drawer_position = positions['drawer']  # Replace with actual drawer key
        rubbish_position = positions['rubbish']  # Replace with actual rubbish key
        gripper_position = positions['gripper']  # Replace with your gripper's starting position

        # Approach the drawer
        print("[Task] Moving to drawer position:", drawer_position)
        obs, reward, done = move(env, gripper_position, drawer_position)

        if done:
            print("[Task] Task ended after moving to drawer!")
            return

        # Pick the drawer
        print("[Task] Picking the drawer")
        obs, reward, done = pick(env, "drawer", drawer_position, "gripper")

        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Open the drawer
        print("[Task] Rotating to open drawer handle")
        obs, reward, done = rotate(env, task, "target_quat", max_steps=100)

        if done:
            print("[Task] Task ended after rotating!")
            return

        print("[Task] Pulling the drawer open")
        obs, reward, done = pull(env, "gripper", "drawer")

        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Drop the rubbish
        print("[Task] Moving to rubbish position")
        obs, reward, done = move(env, drawer_position, rubbish_position)

        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        print("[Task] Dropping the rubbish")
        obs, reward, done = place(env, "rubbish", rubbish_position)

        if done:
            print("[Task] Task ended after dropping the rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()