def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example object names based on assumptions
        object_name = 'object_1'  
        drawer_name = 'drawer_1'

        # Get the initial positions of the relevant objects
        object_pos = positions[object_name]  
        drawer_pos = positions[drawer_name]

        # Move to the object's position
        print(f"[Task] Moving to the position of {object_name} at: {object_pos}")
        obs, reward, done = move(env, 'initial_location', object_pos)

        if done:
            print("[Task] Task ended during moving!")
            return
        
        # Pick the object
        print(f"[Task] Picking up {object_name}")
        obs, reward, done = pick(env, object_name, object_pos, 'gripper')

        if done:
            print("[Task] Task ended during picking!")
            return

        # Move to the drawer position (assumed to be opening or interacting)
        print(f"[Task] Moving to the drawer at: {drawer_pos}")
        obs, reward, done = move(env, object_pos, drawer_pos)

        if done:
            print("[Task] Task ended during moving to drawer!")
            return
        
        # Open the drawer
        print(f"[Task] Opening the drawer: {drawer_name}")
        obs, reward, done = pull(env, 'gripper', drawer_name)

        if done:
            print("[Task] Task ended during pulling!")
            return
        
        # Place the object in the drawer
        print(f"[Task] Placing {object_name} in the drawer")
        obs, reward, done = place(env, object_name, drawer_pos)

        if done:
            print("[Task] Task ended during placing!")
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()