def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        bottom_drawer_pos = positions['bottom_drawer']
        middle_drawer_pos = positions['middle_drawer']
        rubbish_pos = positions['rubbish_bin']

        # 1) Move to bottom drawer position
        print("[Task] Moving to bottom drawer position:", bottom_drawer_pos)
        obs, reward, done = move(env, task, 'current_room', bottom_drawer_pos)
        if done:
            print("[Task] Task ended after moving to bottom drawer!")
            return
        
        # 2) Open the bottom drawer
        print("[Task] Opening the bottom drawer.")
        obs, reward, done = rotate(env, task, 'bottom_drawer_open_orientation')
        if done:
            print("[Task] Task ended after opening the bottom drawer!")
            return
        
        # 3) Pick up the rubbish from the bottom drawer
        print("[Task] Picking up rubbish.")
        obs, reward, done = pick(env, 'rubbish', bottom_drawer_pos)
        if done:
            print("[Task] Task ended after picking up the rubbish!")
            return
        
        # 4) Move to rubbish bin position
        print("[Task] Moving to rubbish bin position:", rubbish_pos)
        obs, reward, done = move(env, task, bottom_drawer_pos, rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish bin!")
            return
        
        # 5) Place the rubbish in the bin
        print("[Task] Placing rubbish in the bin.")
        obs, reward, done = place(env, 'rubbish', rubbish_pos)
        if done:
            print("[Task] Task ended after placing the rubbish into the bin!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()