def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the relevant objects are 'drawer' and 'bin'.
        drawer_pos = positions['drawer']
        bin_pos = positions['bin']
        gripper_position = obs.gripper_pose[:3]

        # Step 1: Approach the drawer
        print("[Task] Moving to drawer at:", drawer_pos)
        obs, reward, done = move(env, obs.robot_at, drawer_pos)

        # Check if the task ended early
        if done:
            print("[Task] Task ended while approaching the drawer!")
            return

        # Step 2: Pick up the drawer handle
        print("[Task] Picking the drawer handle.")
        obs, reward, done = pick(env, 'drawer_handle', drawer_pos, obs.gripper)

        if done:
            print("[Task] Task ended after picking the drawer handle!")
            return

        # Step 3: Pull the drawer open
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, task, pull_distance=0.2)  # Assuming 0.2 is the distance for pulling the drawer

        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Step 4: Move to the bin to dispose of the rubbish
        print("[Task] Moving to bin at:", bin_pos)
        obs, reward, done = move(env, obs.robot_at, bin_pos)

        if done:
            print("[Task] Task ended while moving to the bin!")
            return

        # Step 5: Place the rubbish in the bin
        print("[Task] Placing the rubbish in the bin.")
        obs, reward, done = place(env, 'rubbish', bin_pos)

        if done:
            print("[Task] Task ended after placing the rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()