def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the object names are set in positions
        bottom_drawer_position = positions['bottom_drawer']
        middle_drawer_position = positions['middle_drawer']
        top_drawer_position = positions['top_drawer']
        bottom_side_pos = positions['bottom_side_pos']
        middle_side_pos = positions['middle_side_pos']
        top_side_pos = positions['top_side_pos']
        bottom_anchor_pos = positions['bottom_anchor_pos']
        middle_anchor_pos = positions['middle_anchor_pos']
        top_anchor_pos = positions['top_anchor_pos']
        
        # Example robot controls that might be needed as per tasks goals:
        # 1. Move to the position of bottom drawer's side
        print("[Task] Moving to bottom side position.")
        obs, reward, done = move(env, 'current_position', bottom_side_pos)
        if done:
            return
        
        # 2. Pick the bottom drawer
        print("[Task] Picking bottom drawer.")
        obs, reward, done = pick(env, 'bottom_drawer', bottom_drawer_position)
        if done:
            return
        
        # 3. Rotate gripper if necessary (example)
        print("[Task] Rotating gripper to position.")
        rotate(env, task, target_quat=bottom_anchor_pos)  # This would need actual quaternion values

        # 4. Place the bottom drawer (or, if open, it might be manipulate)
        print("[Task] Placing bottom drawer.")
        obs, reward, done = place(env, 'bottom_drawer', bottom_drawer_position)
        if done:
            return
        
        # Following the same sequence for middle and top drawers
        print("[Task] Moving to middle side position.")
        obs, reward, done = move(env, 'current_position', middle_side_pos)
        if done:
            return

        print("[Task] Picking middle drawer.")
        obs, reward, done = pick(env, 'middle_drawer', middle_drawer_position)
        if done:
            return
        
        print("[Task] Rotating gripper for middle drawer.")
        rotate(env, task, target_quat=middle_anchor_pos)
        
        print("[Task] Placing middle drawer.")
        obs, reward, done = place(env, 'middle_drawer', middle_drawer_position)
        if done:
            return
        
        print("[Task] Moving to top side position.")
        obs, reward, done = move(env, 'current_position', top_side_pos)
        if done:
            return
        
        print("[Task] Picking top drawer.")
        obs, reward, done = pick(env, 'top_drawer', top_drawer_position)
        if done:
            return
        
        print("[Task] Rotating gripper for top drawer.")
        rotate(env, task, target_quat=top_anchor_pos)
        
        print("[Task] Placing top drawer.")
        obs, reward, done = place(env, 'top_drawer', top_drawer_position)
        if done:
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()