def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Extract object positions
        bottom_side_pos = positions['bottom_side_pos']
        bottom_anchor_pos = positions['bottom_anchor_pos']
        bin_position = positions['bin']
        rubbish_position = positions['rubbish']
        
        # 1) Move to bottom side position
        print("[Task] Moving to bottom-side position...")
        obs, reward, done = move(env, task, bottom_side_pos, max_steps=100, threshold=0.01)
        if done:
            print("[Task] Task ended after moving to bottom side position!")
            return
        
        # 2) Pick the drawer
        print("[Task] Picking drawer...")
        obs, reward, done = pick(env, 'drawer_object', bottom_side_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # 3) Pull the drawer to open it
        print("[Task] Pulling the drawer open...")
        obs, reward, done = pull(env, 'drawer_object', bottom_anchor_pos)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # 4) Move to grab rubbish
        print("[Task] Moving to rubbish...")
        obs, reward, done = move(env, task, rubbish_position, max_steps=100, threshold=0.01)
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return
            
        # 5) Pick the rubbish
        print("[Task] Picking rubbish...")
        obs, reward, done = pick(env, 'rubbish', rubbish_position)
        if done:
            print("[Task] Task ended after picking rubbish!")
            return

        # 6) Move to bin
        print("[Task] Moving to bin...")
        obs, reward, done = move(env, task, bin_position, max_steps=100, threshold=0.01)
        if done:
            print("[Task] Task ended after moving to bin!")
            return
            
        # 7) Place rubbish in bin
        print("[Task] Placing rubbish in bin...")
        obs, reward, done = place(env, 'rubbish', bin_position)
        if done:
            print("[Task] Task ended after placing rubbish in bin!")
            return
        
    finally:
        # Ensure proper shutdown of the environment
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")