def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve Object Positions
        positions = get_object_positions()

        # Assuming the drawer is in 'bottom_anchor_pos' and we need to throw away trash
        gripper = "gripper"  # Assuming an identifier for the gripper
        trash_position = positions['rubbish']
        drawer_position = positions['bottom_anchor_pos']

        # Step 1: Move to drawer position
        print("Moving to drawer position...")
        obs, reward, done = move(env, task, drawer_position)
        if done:
            print("Task ended during moving to drawer position!")
            return

        # Step 2: Pick the drawer
        print("Picking the drawer...")
        obs, reward, done = pick(env, 'bottom', drawer_position, gripper)
        if done:
            print("Task ended during picking the drawer!")
            return

        # Step 3: Pull the drawer to open
        print("Pulling the drawer to open it...")
        obs, reward, done = pull(env, 'bottom', gripper)
        if done:
            print("Task ended during pulling the drawer!")
            return

        # Step 4: Move to trash position
        print("Moving to trash position...")
        obs, reward, done = move(env, task, trash_position)
        if done:
            print("Task ended during moving to trash position!")
            return

        # Step 5: Pick the trash
        print("Picking the trash...")
        obs, reward, done = pick(env, 'rubbish', trash_position, gripper)
        if done:
            print("Task ended during picking the trash!")
            return

        # Step 6: Place the trash in the bin (assuming 'bin' position is known)
        bin_position = positions['bin']
        print("Moving to bin position...")
        obs, reward, done = move(env, task, bin_position)
        if done:
            print("Task ended during moving to bin position!")
            return

        # Step 7: Place the trash in the bin
        print("Placing the trash in the bin...")
        obs, reward, done = place(env, 'rubbish', bin_position)
        if done:
            print("Task ended during placing the trash!")
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")