def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assuming we know the locations of the gripper and objects
        trash_pos = positions['rubbish']
        bin_pos = positions['bin']
        cabinet_pos = positions['drawer']
        drawer_anchor_pos = positions['drawer_anchor']
        
        # Approach cabinet and unlock the drawer
        print("[Task] Moving to cabinet to unlock.")
        obs, reward, done = move(env, task, target_pos=cabinet_pos)
        
        # Picking the drawer
        print("[Task] Picking drawer.")
        obs, reward, done = pick(env, 'drawer_handle', cabinet_pos, 'gripper')
        
        # Unlocking the drawer
        print("[Task] Pulling to unlock the drawer.")
        obs, reward, done = pull(env, 'drawer_handle', cabinet_pos)
        
        # Opening the drawer
        print("[Task] Opening the drawer.")
        obs, reward, done = rotate(env, 'gripper', current_angle, open_angle)

        # Moving the trash to the drawer
        print("[Task] Moving to rubbish to pick it up.")
        obs, reward, done = move(env, task, target_pos=trash_pos)
        
        # Picking up the rubbish
        print("[Task] Picking up rubbish.")
        obs, reward, done = pick(env, 'rubbish', trash_pos)

        # Moving to the bin to dispose of the rubbish
        print("[Task] Moving to the bin.")
        obs, reward, done = move(env, task, target_pos=bin_pos)

        # Placing the rubbish in the bin
        print("[Task] Placing rubbish in the bin.")
        obs, reward, done = place(env, 'rubbish', bin_pos)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()