def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects and positions available
        drawer_bottom_pos = positions['bottom_side_pos']
        drawer_bottom_anchor_pos = positions['bottom_anchor_pos']
        rubbish_pos = positions['rubbish']
        
        # Define the skill name for easier access
        gripper = 'gripper'
        drawer = 'drawer_bottom'
        
        # Step 1: Move to the drawer's side position
        print("[Task] Moving to the drawer's side position.")
        obs, reward, done = move(env, gripper, obs.robot_position, drawer_bottom_pos)
        if done:
            print("[Task] Task ended during moving to side position!")
            return

        # Step 2: Pick the drawer with the gripper
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, drawer, obs.robot_position, gripper)
        if done:
            print("[Task] Task ended during picking the drawer!")
            return

        # Step 3: Open the drawer (assuming it's locked)
        print("[Task] Pulling the drawer to open it.")
        obs, reward, done = pull(env, gripper, drawer, obs.robot_position)
        if done:
            print("[Task] Task ended during pulling the drawer!")
            return

        # Step 4: Move to the rubbish’s position
        print("[Task] Moving to the rubbish's position.")
        obs, reward, done = move(env, gripper, obs.robot_position, rubbish_pos)
        if done:
            print("[Task] Task ended during moving to rubbish!")
            return

        # Step 5: Pick the rubbish
        print("[Task] Picking the rubbish.")
        obs, reward, done = pick(env, 'rubbish', obs.robot_position, gripper)
        if done:
            print("[Task] Task ended during picking rubbish!")
            return

        # Step 6: Move back to the disposal area (assuming it’s a known area)
        print("[Task] Moving back to the disposal area.")
        obs, reward, done = move(env, gripper, rubbish_pos, 'disposal_area')
        if done:
            print("[Task] Task ended during returning to disposal area!")
            return

        # Step 7: Place the rubbish in the disposal area
        print("[Task] Placing the rubbish in the disposal area.")
        obs, reward, done = place(env, 'rubbish', 'disposal_area')
        if done:
            print("[Task] Task ended during placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()