def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Define placeholders for object positions
        bottom_drawer_pos = positions['bottom_drawer']  # An example for a drawer position
        rubbish_pos = positions['rubbish']  # Example for the rubbish
        bin_pos = positions['bin']  # An example for bin position
        gripper_pos = positions['gripper']  # Position of the gripper

        # Step 1: Move to the bottom drawer
        print("[Task] Moving to the bottom drawer position:", bottom_drawer_pos)
        obs, reward, done = move(env, gripper_pos, bottom_drawer_pos)
        if done:
            return

        # Step 2: Rotate gripper to suitable position to pick the drawer handle
        print("[Task] Rotating gripper to pick drawer.")
        obs, reward, done = rotate(env, task, target_quat=[0, 0, 0, 1])  # Assuming this is the desired quat
        if done:
            return

        # Step 3: Pick the bottom drawer
        print("[Task] Picking the bottom drawer.")
        obs, reward, done = pick(env, 'bottom_drawer_handle', bottom_drawer_pos, gripper_pos)
        if done:
            return

        # Step 4: Pull open the bottom drawer
        print("[Task] Pulling open the bottom drawer.")
        obs, reward, done = pull(env, 'bottom_drawer', bottom_drawer_pos)
        if done:
            return
        
        # Step 5: Move to rubbish
        print("[Task] Moving to rubbish position:", rubbish_pos)
        obs, reward, done = move(env, bottom_drawer_pos, rubbish_pos)
        if done:
            return

        # Step 6: Pick up rubbish
        print("[Task] Picking rubbish.")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos, gripper_pos)
        if done:
            return
        
        # Step 7: Move to bin
        print("[Task] Moving to bin position:", bin_pos)
        obs, reward, done = move(env, rubbish_pos, bin_pos)
        if done:
            return
        
        # Step 8: Drop rubbish into the bin
        print("[Task] Dropping rubbish into the bin.")
        obs, reward, done = place(env, 'rubbish', bin_pos)
        if done:
            return
        
        # Step 9: Place the drawer back
        print("[Task] Placing the drawer back.")
        obs, reward, done = place(env, 'bottom_drawer', bottom_drawer_pos)
        if done:
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()