def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        gripper = "gripper"  # Assuming one gripper is available
        rubbish = "rubbish"  # Name of the rubbish object
        drawer = "drawer"    # Name of the drawer object
        bin_location = "bin"  # Location name for the bin

        # Step 1: Move to the drawer
        print("[Task] Moving to the drawer.")
        obs, reward, done = move(env, task, "current_location", "drawer_location")
        if done:
            print("[Task] Ended after moving to the drawer.")
            return

        # Step 2: Open the drawer by moving to its handle and pulling it
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, drawer, "drawer_location", gripper)
        if done:
            print("[Task] Ended after picking the drawer.")
            return

        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, gripper, drawer)
        if done:
            print("[Task] Drawer is now open, ready to access rubbish.")
        
        # Step 3: Move the rubbish into the gripper
        print("[Task] Moving to pick up the rubbish.")
        obs, reward, done = move(env, task, "drawer_location", "rubbish_location")
        if done:
            print("[Task] Ended after moving to rubbish.")
            return

        print("[Task] Picking up the rubbish.")
        obs, reward, done = pick(env, rubbish, "rubbish_location", gripper)
        if done:
            print("[Task] Ended after picking up the rubbish.")
            return
        
        # Step 4: Move to the bin and place the rubbish in it
        print("[Task] Moving to the bin.")
        obs, reward, done = move(env, task, "rubbish_location", bin_location)
        if done:
            print("[Task] Ended after moving to the bin.")
            return

        print("[Task] Placing the rubbish in the bin.")
        obs, reward, done = place(env, rubbish, bin_location)
        if done:
            print("[Task] Successfully placed rubbish in the bin.")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()