def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        bottom_side_pos = positions['bottom_side_pos']
        bottom_anchor_pos = positions['bottom_anchor_pos']
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']
        
        # Move to the rubbish position
        print("[Task] Moving to rubbish position:", rubbish_pos)
        obs, reward, done = move(env, obs.robot_position, rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return
        
        # Pick up the rubbish
        print("[Task] Picking up rubbish!")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos, obs.gripper)
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # Move to the bottom anchor position
        print("[Task] Moving to bottom anchor position:", bottom_anchor_pos)
        obs, reward, done = move(env, obs.robot_position, bottom_anchor_pos)
        if done:
            print("[Task] Task ended after moving to bottom anchor!")
            return

        # Pick the drawer to get it open
        print("[Task] Picking up the bottom drawer!")
        obs, reward, done = pick(env, 'bottom', bottom_anchor_pos, obs.gripper)
        if done:
            print("[Task] Task ended after picking up the bottom drawer!")
            return

        # Pull the drawer to open it
        print("[Task] Pulling the bottom drawer to open!")
        obs, reward, done = pull(env, 'bottom', bottom_anchor_pos)
        if done:
            print("[Task] Task ended after pulling the bottom drawer!")
            return

        # Place the rubbish in the bin
        print("[Task] Moving to the bin position:", bin_pos)
        obs, reward, done = move(env, obs.robot_position, bin_pos)
        if done:
            print("[Task] Task ended after moving to the bin!")
            return

        # Place the rubbish in the bin
        print("[Task] Placing rubbish in the bin!")
        obs, reward, done = place(env, 'rubbish', bin_pos)
        if done:
            print("[Task] Task ended after placing rubbish in the bin!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()