def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Define the drawer and the trash bin positions
        drawer_position = positions['drawer_position']  # Example key for drawer
        bin_position = positions['bin_position']          # Example key for trash bin
        gripper_position = positions['gripper_position']  # Example key for gripper

        # Initialize the gripper (if relevant)
        obs = task.get_observation()
        gripper = obs.gripper_name

        # Step 1: Move to drawer
        print("[Task] Moving to the drawer...")
        obs, reward, done = move(env, gripper, gripper_position, drawer_position)
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return

        # Step 2: Open the drawer
        print("[Task] Opening the drawer...")
        obs, reward, done = pick(env, 'drawer_handle', drawer_position, gripper)
        if done:
            print("[Task] Task ended after trying to pick the drawer handle!")
            return
        
        obs, reward, done = pull(env, gripper, 'drawer_handle', drawer_position)
        if done:
            print("[Task] Task ended after opening the drawer!")
            return
        
        # Step 3: Pick up rubbish
        print("[Task] Picking up rubbish...")
        obs, reward, done = pick(env, 'rubbish_object', drawer_position, gripper)
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # Step 4: Move to the bin
        print("[Task] Moving to the bin...")
        obs, reward, done = move(env, gripper, drawer_position, bin_position)
        if done:
            print("[Task] Task ended after moving to the bin!")
            return

        # Step 5: Place rubbish in bin
        print("[Task] Placing rubbish in the bin...")
        obs, reward, done = place(env, 'rubbish_object', bin_position)
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()