def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assuming the objects are as follows based on the initial state:
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        drawer_bottom_pos = positions['bottom_side_pos']

        # Approach to the first tomato
        print(f"[Task] Moving to tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, task, obs.robot_location, tomato1_pos)
        if done:
            print("[Task] Task ended after moving to tomato1!")
            return

        # Pick up the first tomato
        print("[Task] Picking up tomato1.")
        obs, reward, done = pick(env, 'tomato1', tomato1_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking tomato1!")
            return

        # Move to the drawer's side position
        print(f"[Task] Moving to the drawer's side position at:", drawer_bottom_pos)
        obs, reward, done = move(env, task, obs.robot_location, drawer_bottom_pos)
        if done:
            print("[Task] Task ended after moving to the drawer's side position!")
            return

        # Pick the drawer
        print("[Task] Picking the drawer from the side.")
        obs, reward, done = pick(env, 'drawer_bottom', drawer_bottom_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Pull the drawer open
        print("[Task] Pulling open the drawer.")
        obs, reward, done = pull(env, 'drawer_bottom', obs.robot_location)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Move to the bin position
        print(f"[Task] Moving to the bin at:", bin_pos)
        obs, reward, done = move(env, task, obs.robot_location, bin_pos)
        if done:
            print("[Task] Task ended after moving to the bin!")
            return
        
        # Place the rubbish into the bin
        print("[Task] Placing rubbish into the bin.")
        obs, reward, done = place(env, 'rubbish', bin_pos)
        if done:
            print("[Task] Task ended after placing rubbish into the bin!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()