def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Identify object positions
        bottom_drawer_pos = positions['bottom']
        middle_drawer_pos = positions['middle']
        top_drawer_pos = positions['top']
        trash_can_pos = positions['trash_can']
        gripper_pos = positions['nowhere-pos']
        
        # Open the bottom drawer
        print("[Task] Moving to bottom drawer's position")
        move(env, gripper_pos, bottom_drawer_pos)
        
        print("[Task] Opening the bottom drawer")
        pull(env, bottom_drawer_pos)

        # Assume the rubbish is identified in the bottom drawer
        print("[Task] Picking rubbish from the bottom drawer")
        pick(env, 'rubbish_object', bottom_drawer_pos) # Replace 'rubbish_object' with actual object name

        print("[Task] Moving to trash can")
        move(env, bottom_drawer_pos, trash_can_pos)

        print("[Task] Placing rubbish in trash can")
        place(env, 'rubbish_object', trash_can_pos) # Replace 'rubbish_object' with actual object name

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()