def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Extract necessary positions
        trash_can_pos = positions['trash_can']
        drawer_pos = positions['drawer']
        rubbish_pos = positions['rubbish']

        # Step 1: Move to the drawer
        print("[Task] Moving to the drawer position:", drawer_pos)
        obs, reward, done = move(env, "current_location", drawer_pos)

        if done:
            print("[Task] Task ended while moving to the drawer!")
            return
            
        # Step 2: Open the drawer
        print("[Task] Opening the drawer")
        obs, reward, done = pull(env, "gripper", "drawer")

        if done:
            print("[Task] Task ended while opening the drawer!")
            return
            
        # Step 3: Pick up the rubbish
        print("[Task] Picking up the rubbish")
        obs, reward, done = pick(env, "rubbish", drawer_pos)

        if done:
            print("[Task] Task ended while picking up the rubbish!")
            return
            
        # Step 4: Place the rubbish in the trash can
        print("[Task] Placing the rubbish in the trash can")
        obs, reward, done = place(env, "rubbish", trash_can_pos)

        if done:
            print("[Task] Task ended while placing rubbish in the trash can!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()