def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")

    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming positions contain the objects and their respective locations
        object_pos = { 
            'ball': positions['ball'],
            'drawer': positions['drawer'] 
        }

        # Example Task Plan
        # 1) Move to the location of the object (ball)
        print("[Task] Moving to the ball's position:", object_pos['ball'])
        obs, reward, done = move(env, obs.robot_location, object_pos['ball'])
        if done:
            print("[Task] Task ended after moving to the ball!")
            return

        # 2) Pick the object (ball)
        print("[Task] Picking up the ball.")
        obs, reward, done = pick(env, 'ball', object_pos['ball'], 'gripper')  # Assuming 'gripper' is the identifier for the robot's gripper
        if done:
            print("[Task] Task ended after picking the ball!")
            return

        # 3) Move to the drawer's position
        print("[Task] Moving to the drawer's position:", object_pos['drawer'])
        obs, reward, done = move(env, obs.robot_location, object_pos['drawer'])
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return

        # 4) Place the object (ball) in the drawer
        print("[Task] Placing the ball in the drawer.")
        obs, reward, done = place(env, 'ball', object_pos['drawer'])
        if done:
            print("[Task] Task ended after placing the ball!")
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()