def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Extract positions of relevant objects
        robot_pos = positions['robot']
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']
        drawer_pos = positions['drawer']
        side_pos = positions['side_pos']
        anchor_pos = positions['anchor_pos']

        # === Execute the Plan ===
        
        # Step 1: Move to the drawer
        print("[Task] Moving to the drawer...")
        move(env, robot_pos, drawer_pos)
        
        # Step 2: Open the drawer (assuming the drawer is closed)
        print("[Task] Picking the drawer...")
        pick(env, 'drawer_handle', drawer_pos, 'gripper1')  # Using a hypothetical gripper
        print("[Task] Pulling the drawer to open...")
        pull(env, 'gripper1', 'drawer')

        # Step 3: Check for rubbish
        print("[Task] Checking for rubbish...")
        if obs['rubbish'] is not None:  # Assumes presence of rubbish can be checked
            # Step 4: Pick up the rubbish
            print("[Task] Picking up the rubbish...")
            pick(env, 'rubbish', rubbish_pos, 'gripper1')
            
            # Step 5: Place rubbish in the bin
            print("[Task] Placing rubbish in the bin...")
            place(env, 'rubbish', bin_pos)
        else:
            print("[Task] No rubbish found!")

        print("[Task] Task completed.")

    except Exception as e:
        print(f"Error occurred: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()