import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import * 

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions


def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example object positions
        bottom_drawer_pos = positions['bottom']
        middle_drawer_pos = positions['middle']
        top_drawer_pos = positions['top']
        gripper_pos = positions['gripper']

        # === Example Task Plan ===
        # Step 1: Move to the bottom drawer position
        print("[Task] Moving to the bottom drawer position.")
        move(env, gripper_pos, bottom_drawer_pos)

        # Step 2: Open the bottom drawer
        print("[Task] Opening the bottom drawer.")
        # Rotate gripper to side position
        rotate(env, 'gripper', 'zero_deg', 'ninety_deg')
        # Move to side
        move_to_side(env, 'gripper', 'bottom_drawer', 'middle_pos', 'side-pos-bottom')
        
        # Pull the drawer open
        pull(env, 'gripper', 'bottom_drawer')

        # Step 3: Pick up the rubbish
        print("[Task] Picking up the rubbish.")
        pick(env, 'rubbish', 'table', 'gripper')

        # Step 4: Move to disposal position
        disposal_pos = positions['bin']
        print("[Task] Moving to bin position to dispose of rubbish.")
        move(env, bottom_drawer_pos, disposal_pos)

        # Step 5: Place rubbish in the bin
        print("[Task] Placing rubbish in the bin.")
        place(env, 'rubbish', disposal_pos)

        # Step 6: Close the drawer if necessary
        print("[Task] Closing the bottom drawer back.")
        # Rotate back to the anchor position
        rotate(env, 'gripper', 'ninety_deg', 'zero_deg')
        # Move to anchor position
        move_to_anchor(env, 'gripper', 'bottom_drawer', 'side-pos-bottom', 'anchor-pos-bottom')
        
        # Close the drawer
        # Logic to handle closing drawer (if applicable) based on environment setup
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()