def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Define relevant positions
        gripper_position = positions['gripper']
        rubbish_position = positions['rubbish']
        drawer_position = positions['drawer']
        bin_position = positions['bin']
        drawer_anchor_pos = positions['drawer_anchor_pos']
        drawer_side_pos = positions['drawer_side_pos']

        # Step 1: Move to the drawer's side position
        print("[Task] Moving to drawer's side position.")
        obs, reward, done = move(env, gripper_position, drawer_side_pos)
        if done:
            print("[Task] Task ended after moving to drawer's side position!")
            return

        # Step 2: Rotate gripper to unfasten the drawer
        print("[Task] Opening the drawer.")
        obs, reward, done = pull(env, task, drawer_position)
        if done:
            print("[Task] Task ended after opening the drawer!")
            return

        # Step 3: Move to rubbish position to pick it up
        print("[Task] Moving to pick up rubbish.")
        obs, reward, done = move(env, gripper_position, rubbish_position)
        if done:
            print("[Task] Task ended after moving to rubbish position!")
            return

        # Step 4: Pick up rubbish
        print("[Task] Picking up rubbish.")
        obs, reward, done = pick(env, 'rubbish', rubbish_position)
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # Step 5: Move to bin position to deposit rubbish
        print("[Task] Moving to the bin position to dispose of rubbish.")
        obs, reward, done = move(env, rubbish_position, bin_position)
        if done:
            print("[Task] Task ended after moving to bin position!")
            return

        # Step 6: Place rubbish in the bin
        print("[Task] Disposing the rubbish in the bin.")
        obs, reward, done = place(env, 'rubbish', bin_position)
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()