def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Retrieve relevant object positions
        bottom_side_pos = positions['bottom_side_pos']
        bottom_anchor_pos = positions['bottom_anchor_pos']
        middle_side_pos = positions['middle_side_pos']
        middle_anchor_pos = positions['middle_anchor_pos']
        top_side_pos = positions['top_side_pos']
        top_anchor_pos = positions['top_anchor_pos']
        
        # Step 1: Move to bottom drawer
        obs, reward, done = move(env, 'robby', 'initial_position', bottom_side_pos)
        
        # Step 2: Check if bottom drawer is locked
        if obs['is-locked bottom']:
            # Step 3: If locked, pick the bottom drawer handle
            print("[Task] Unlocking bottom drawer...")
            obs, reward, done = pick(env, 'bottom_handle', bottom_side_pos)
            # Step 4: Now pull the drawer
            obs, reward, done = pull(env, 'bottom_drawer', bottom_side_pos)

        # Step 5: Repeat for middle drawer
        obs, reward, done = move(env, 'robby', bottom_side_pos, middle_side_pos)
        if obs['is-locked middle']:
            print("[Task] Unlocking middle drawer...")
            obs, reward, done = pick(env, 'middle_handle', middle_side_pos)
            obs, reward, done = pull(env, 'middle_drawer', middle_side_pos)
        
        # Step 6: Move to top drawer
        obs, reward, done = move(env, 'robby', middle_side_pos, top_side_pos)
        if obs['is-locked top']:
            print("[Task] Unlocking top drawer...")
            obs, reward, done = pick(env, 'top_handle', top_side_pos)
            obs, reward, done = pull(env, 'top_drawer', top_side_pos)

        # Step 7: After drawers are opened, chuck the rubbish
        print("[Task] Picking up rubbish and chucking it away...")
        obs, reward, done = pick(env, 'rubbish', 'table', 'gripper')
        obs, reward, done = place(env, 'rubbish', 'bin')

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()