def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Assuming we know the object names we'll manipulate
        drawer1_pos = positions['drawer1']
        gripper1 = 'gripper1'  # Example of a gripper name
        robot_initial_loc = 'room_a'  # Example initial location for the robot
        
        # 1. Move to the initial location
        print("[Task] Moving to initial location:", robot_initial_loc)
        obs, reward, done = move(env, robot_initial_loc, robot_initial_loc)
        if done:
            print("[Task] Task ended after moving to initial location!")
            return

        # 2. Approach the drawer
        print("[Task] Approaching the drawer.")
        obs, reward, done = move(env, robot_initial_loc, drawer1_pos)
        if done:
            print("[Task] Task ended after approaching the drawer!")
            return
        
        # 3. Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick_door(env, gripper1, 'drawer1', drawer1_pos)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return
        
        # 4. Open the drawer if it's not already open
        print("[Task] Pulling the drawer to open it.")
        obs, reward, done = pull(env, gripper1, 'drawer1')
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # 5. Place the item back in the drawer
        print("[Task] Placing the item back in the drawer.")
        obs, reward, done = place(env, 'item_name', drawer1_pos)
        if done:
            print("[Task] Task ended after placing the item back!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()