def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        # Replace these with actual object names from your environment
        drawer = 'bottom'
        robot_position = 'initial_position'  # Replace with actual initial position
        target_position = positions[drawer]  # Get the position of the drawer

        # Step 1: Move to the drawer's position
        print("[Task] Moving to the drawer at:", target_position)
        move(env, robot_position, target_position)

        # Step 2: Check if the drawer is locked
        if not is_locked(drawer):  # Assuming a function to check if the drawer is locked
            # Step 3: Open the drawer
            print("[Task] Opening the drawer.")
            pull(env, drawer)

        # Step 4: Pick an object from the drawer (assuming we know the object)
        object_to_pick = 'object_name'  # Replace with actual object name
        print("[Task] Picking the object:", object_to_pick)
        pick(env, object_to_pick, target_position)

        # Step 5: Place the object somewhere (assuming we have a target location)
        place_location = 'target_location'  # Replace with actual target location
        print("[Task] Placing the object at:", place_location)
        place(env, object_to_pick, place_location)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()