(define (domain combined-domain)

  (:requirements :strips :typing :negative-preconditions :equality :disjunctive-preconditions)

  (:types

    object

    location

    drawer - object

    gripper - object

    position - object

    angle - object

  )

  (:predicates

    (at ?obj - object ?loc - location)

    (holding ?obj - object)

    (handempty)

    (is-locked ?d - drawer)

    (is-open ?d - drawer)

    (rotated ?g - gripper ?a - angle)

    (gripper-at ?g - gripper ?p - position)

    (holding-drawer ?g - gripper ?d - drawer)

    (is-side-pos ?p - position ?d - drawer)

    (is-anchor-pos ?p - position ?d - drawer)

  )

  (:action pick

    :parameters (?obj - object ?loc - location)

    :precondition (and

      (at ?obj ?loc)

      (handempty)

    )

    :effect (and

      (holding ?obj)

      (not (handempty))

      (not (at ?obj ?loc))

    )

  )

  (:action place

    :parameters (?obj - object ?loc - location)

    :precondition (and

      (holding ?obj)

    )

    :effect (and

      (at ?obj ?loc)

      (handempty)

      (not (holding ?obj))

    )

  )

  (:action rotate

    :parameters (?g - gripper ?from - angle ?to - angle)

    :precondition (and

      (rotated ?g ?from)

      (not (= ?from ?to))

    )

    :effect (and

      (not (rotated ?g ?from))

      (rotated ?g ?to)

    )

  )

  (:action move-to-side

    :parameters (?g - gripper ?d - drawer ?from ?to - position)

    :precondition (and

      (gripper-at ?g ?from)

      (is-side-pos ?to ?d)

      (not (gripper-at ?g ?to))

      (rotated ?g ninety_deg)

    )

    :effect (and

      (gripper-at ?g ?to)

      (not (gripper-at ?g ?from))

    )

  )

  (:action move-to-anchor

    :parameters (?g - gripper ?d - drawer ?from ?to - position)

    :precondition (and

      (is-side-pos ?from ?d)

      (is-anchor-pos ?to ?d)

      (gripper-at ?g ?from)

      (not (gripper-at ?g ?to))

    )

    :effect (and

      (gripper-at ?g ?to)

      (not (gripper-at ?g ?from))

    )

  )

  (:action pick-drawer

    :parameters (?g - gripper ?d - drawer ?p - position)

    :precondition (and

      (gripper-at ?g ?p)

      (is-anchor-pos ?p ?d)

      (not (holding-drawer ?g ?d))

    )

    :effect (holding-drawer ?g ?d)

  )

  (:action pull

    :parameters (?g - gripper ?d - drawer)

    :precondition (and

      (holding-drawer ?g ?d)

      (not (is-locked ?d))

      (not (is-open ?d))

    )

    :effect (is-open ?d)

  )

)
