import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")

    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Pull open any drawer that is not locked
        print("[Task] Pulling open the bottom drawer that is not locked...")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')  # Adjust pull parameters as needed

        # Check if drawer is open before proceeding
        if not done:
            print("[Task] Drawer could not be opened. Exiting the task.")
            return

        # Pick tomato1 and place it on the plate
        print("[Task] Picking tomato1.")
        obs, reward, done = pick(env, task, target_pos=positions['tomato1'], approach_distance=0.15)
        if done:
            print("[Task] Tomato1 picked successfully.")

            print("[Task] Placing tomato1 on the plate.")
            obs, reward, done = place(env, task, target_pos=positions['plate'])
            if done:
                print("[Task] Tomato1 placed successfully on the plate!")
            else:
                print("[Task] Failed to place tomato1 on the plate.")
        else:
            print("[Task] Failed to pick tomato1.")

        # Pick tomato2 and place it on the plate
        print("[Task] Picking tomato2.")
        obs, reward, done = pick(env, task, target_pos=positions['tomato2'], approach_distance=0.15)
        if done:
            print("[Task] Tomato2 picked successfully.")

            print("[Task] Placing tomato2 on the plate.")
            obs, reward, done = place(env, task, target_pos=positions['plate'])
            if done:
                print("[Task] Tomato2 placed successfully on the plate!")
            else:
                print("[Task] Failed to place tomato2 on the plate.")
        else:
            print("[Task] Failed to pick tomato2.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()