def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assuming the positions dictionary has been filled with necessary coords
        bottom_drawer_pos = positions['bottom_drawer']
        middle_drawer_pos = positions['middle_drawer']
        top_drawer_pos = positions['top_drawer']
        plate_pos = positions['plate']

        # Example Plan:
        # 1) Open the bottom drawer.
        print("[Task] Opening the bottom drawer.")
        obs, reward, done = pick(env, 'drawer_handle_bottom', bottom_drawer_pos)
        if done:
            print("[Task] Task ended after picking the drawer handle!")
            return
        
        obs, reward, done = pull(env, 'drawer_handle_bottom', bottom_drawer_pos)
        if done:
            print("[Task] Task ended after pulling the drawer handle!")
            return

        # 2) After opening the drawer, pick up all tomatoes.
        print("[Task] Picking up tomatoes from the bottom drawer.")
        # Assume we know the tomato objects
        tomatoes = ['tomato_1', 'tomato_2', 'tomato_3']  # List of tomato object names
        for tomato in tomatoes:
            obs, reward, done = pick(env, tomato, bottom_drawer_pos)
            if done:
                print(f"[Task] Task ended after picking {tomato}!")
                return
            
            # 3) Place the tomato on the plate.
            print(f"[Task] Placing {tomato} on the plate.")
            obs, reward, done = place(env, tomato, plate_pos)
            if done:
                print(f"[Task] Task ended after placing {tomato} on the plate!")
                return

        # 4) Close the drawer (if applicable)
        print("[Task] Closing the bottom drawer.")
        # This step can be added if there's a close action
        # obs, reward, done = close(env, 'bottom_drawer_handle', bottom_drawer_pos)
        # if done:
        #     print("[Task] Task ended after closing the bottom drawer!")
        #     return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()