def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")

    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects and their positions in the environment are known.
        tomato_position = positions['tomato']
        drawer_bottom_position = positions['bottom_anchor_pos']
        drawer_middle_position = positions['middle_anchor_pos']
        drawer_top_position = positions['top_anchor_pos']

        # Step-by-step task execution
        # 1) Move to the drawer's bottom position
        print("[Task] Moving to drawer's bottom position.")
        obs, reward, done = move(env, 'robot', obs.robot_location, drawer_bottom_position)
        
        if done:
            print("[Task] Task ended after moving to drawer's bottom position!")
            return

        # 2) Open the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, 'drawer', drawer_bottom_position, 'gripper')
        
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, 'gripper', 'drawer', drawer_bottom_position)
        
        if done:
            print("[Task] Task ended after pulling the drawer open!")
            return

        # 3) Pick the tomato from the drawer
        print("[Task] Picking the tomato from the drawer.")
        obs, reward, done = pick(env, 'tomato', drawer_middle_position)

        if done:
            print("[Task] Task ended after picking the tomato!")
            return

        # 4) Place the tomato on the plate (assuming plate is at top position)
        print("[Task] Placing the tomato on the plate.")
        obs, reward, done = place(env, 'tomato', drawer_top_position)

        if done:
            print("[Task] Task ended after placing the tomato on the plate!")
            return
    
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()