def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Defining the positions based on the assumed naming in positions dictionary
        bottom_anchor_pos = positions['bottom_anchor_pos']
        bottom_side_pos = positions['bottom_side_pos']
        plate_pos = positions['plate_pos']
        tomato_pos = positions['tomato_pos']

        # Step 1: Approach and pick the tomato
        print("[Task] Approaching and picking up the tomato.")
        obs, reward, done = move(env, task, obs.gripper_pose[:3], tomato_pos)
        if done:
            print("[Task] Task ended while approaching the tomato!")
            return

        obs, reward, done = pick(env, 'tomato', 'table', 'gripper')
        if done:
            print("[Task] Task ended after picking up the tomato!")
            return

        # Step 2: Open the drawer
        print("[Task] Approaching the drawer to open it.")
        obs, reward, done = move(env, task, obs.gripper_pose[:3], bottom_side_pos)
        if done:
            print("[Task] Task ended while approaching the drawer!")
            return
            
        print("[Task] Picking the drawer handle.")
        obs, reward, done = pick(env, 'drawer_handle', 'drawer', 'gripper')
        if done:
            print("[Task] Task ended after picking the drawer handle!")
            return
            
        print("[Task] Pulling to open the drawer.")
        obs, reward, done = pull(env, 'drawer_handle', 'drawer')
        if done:
            print("[Task] Task ended after attempting to pull the drawer!")
            return

        # Step 3: Place the tomato on the plate
        print("[Task] Moving to place the tomato on the plate.")
        obs, reward, done = move(env, task, obs.gripper_pose[:3], plate_pos)
        if done:
            print("[Task] Task ended while moving to the plate position!")
            return
            
        print("[Task] Placing the tomato on the plate.")
        obs, reward, done = place(env, 'tomato', plate_pos)
        if done:
            print("[Task] Task ended after placing the tomato on the plate!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()