def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Extract positions for objects of interest
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        plate_pos = positions['plate']
        drawer_pos = positions['drawer']  # Assuming drawer position is available
        gripper_pos = positions['gripper']  # Assuming gripper position is available

        # 1) Move to the drawer position to pull the drawer open
        print(f"[Task] Moving to drawer at: {drawer_pos}")
        obs, reward, done = move(env, gripper_pos, drawer_pos)

        if done:
            print("[Task] Task ended while moving to drawer!")
            return 

        # 2) If the drawer is not open, we need to pick it up and pull it open
        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, 'drawer', drawer_pos)

        if done:
            print("[Task] Task ended while pulling the drawer!")
            return 

        # 3) After pulling, we can pick the tomatoes
        # For tomato1
        print(f"[Task] Picking tomato1 at: {tomato1_pos}")
        obs, reward, done = pick(env, 'tomato1', tomato1_pos)

        if done:
            print("[Task] Task ended while picking tomato1!")
            return 

        # 4) Place tomato1 on the plate
        print(f"[Task] Placing tomato1 onto plate at: {plate_pos}")
        obs, reward, done = place(env, task, plate_pos)

        if done:
            print("[Task] Task ended while placing tomato1!")
            return 
        
        # For tomato2
        print(f"[Task] Picking tomato2 at: {tomato2_pos}")
        obs, reward, done = pick(env, 'tomato2', tomato2_pos)

        if done:
            print("[Task] Task ended while picking tomato2!")
            return 

        # 5) Place tomato2 on the plate
        print(f"[Task] Placing tomato2 onto plate at: {plate_pos}")
        obs, reward, done = place(env, task, plate_pos)

        if done:
            print("[Task] Task ended while placing tomato2!")
            return 

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")