def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Extracting required positions from the positions dictionary
        drawer_pos = positions.get('drawer')  # The position of the drawer
        plate_pos = positions.get('plate')  # The position of the plate
        tomato1_pos = positions.get('tomato1')  # The position of the first tomato
        tomato2_pos = positions.get('tomato2')  # The position of the second tomato

        # Assuming the gripper is at a fixed initial location
        gripper_initial_pos = (0, 0, 0)  # Replace with actual initial position if available

        # Step 1: Move gripper to drawer position
        obs, reward, done = move(env, gripper_initial_pos, drawer_pos)
        if done:
            print("[Task] Ended after moving to drawer position!")
            return

        # Step 2: Pick the drawer using the gripper
        obs, reward, done = pick(env, 'drawer_handle', drawer_pos, 'gripper')
        if done:
            print("[Task] Ended after picking the drawer handle!")
            return

        # Step 3: Open the drawer
        obs, reward, done = pull(env, 'gripper', 'drawer', drawer_pos)
        if done:
            print("[Task] Ended after pulling the drawer open!")
            return

        # Step 4: Pick the tomatoes one by one
        for tomato in ['tomato1', 'tomato2']:
            obj_pos = positions.get(tomato)

            # Move gripper to the tomato position
            obs, reward, done = move(env, drawer_pos, obj_pos)
            if done:
                print(f"[Task] Ended after moving to {tomato} position!")
                return

            # Pick up the tomato
            obs, reward, done = pick(env, tomato, obj_pos, 'gripper')
            if done:
                print(f"[Task] Ended after picking up {tomato}!")
                return

            # Step 5: Move gripper to plate position
            obs, reward, done = move(env, obj_pos, plate_pos)
            if done:
                print("[Task] Ended after moving to plate position!")
                return

            # Step 6: Place the tomato onto the plate
            obs, reward, done = place(env, tomato, plate_pos)
            if done:
                print(f"[Task] Ended after placing {tomato} on the plate!")
                return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()