def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Extracting specific object positions based on the provided PDDL structure
        tomato1_pos = positions['tomato1']  # Assuming the key matches the object name
        tomato2_pos = positions['tomato2']
        plate_pos = positions['plate']
        bottom_drawer_pos = positions['bottom_drawer']  # Assuming this key exists

        # Approach and pick the first tomato
        print("[Task] Attempting to pick tomato1...")
        obs, reward, done = pick(env, 'tomato1', tomato1_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking tomato1!")
            return
        
        # Move to the bottom drawer
        print("[Task] Moving to bottom drawer...")
        obs, reward, done = move(env, obs['gripper_position'], bottom_drawer_pos)
        if done:
            print("[Task] Task ended while moving to bottom drawer!")
            return
        
        # Open the bottom drawer
        print("[Task] Attempting to pull the bottom drawer...")
        obs, reward, done = pull(env, 'bottom_drawer', obs['gripper_position'])
        if done:
            print("[Task] Task ended after pulling the bottom drawer!")
            return

        # Place the first tomato in the bottom drawer
        print("[Task] Attempting to place tomato1 in the drawer...")
        obs, reward, done = place(env, 'tomato1', bottom_drawer_pos)
        if done:
            print("[Task] Task ended after placing tomato1!")
            return
        
        # Repeat similar steps for the second tomato
        print("[Task] Attempting to pick tomato2...")
        obs, reward, done = pick(env, 'tomato2', tomato2_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking tomato2!")
            return

        # Move to the bottom drawer again
        print("[Task] Moving to bottom drawer...")
        obs, reward, done = move(env, obs['gripper_position'], bottom_drawer_pos)
        if done:
            print("[Task] Task ended while moving to bottom drawer!")
            return
        
        # Place the second tomato in the bottom drawer
        print("[Task] Attempting to place tomato2 in the drawer...")
        obs, reward, done = place(env, 'tomato2', bottom_drawer_pos)
        if done:
            print("[Task] Task ended after placing tomato2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()