def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assume drawer positions and tomatoes' positions
        bottom_drawer_pos = positions['bottom_drawer']   # Position of the bottom drawer
        middle_drawer_pos = positions['middle_drawer']   # Position of the middle drawer
        top_drawer_pos = positions['top_drawer']         # Position of the top drawer
        tomato_pos = positions['tomato']                 # Position of the tomato
        gripper_pos = positions['gripper']               # Position of the gripper
        plate_pos = positions['plate']                   # Position of the plate

        # === Execution Plan ===
        # Step 1: Move to the tomato position
        print("[Task] Moving to the tomato position.")
        obs, reward, done = move(env, gripper_pos, tomato_pos)
        if done:
            return

        # Step 2: Pick the tomato
        print("[Task] Picking up the tomato.")
        obs, reward, done = pick(env, 'tomato', tomato_pos, 'gripper')
        if done:
            return

        # Step 3: Move to the bottom drawer's side position
        print("[Task] Moving to the bottom drawer's side position.")
        obs, reward, done = move(env, gripper_pos, 'bottom_side_pos')
        if done:
            return

        # Step 4: Pick the bottom drawer
        print("[Task] Picking the bottom drawer.")
        obs, reward, done = pick_drawer(env, 'gripper', 'bottom_drawer', 'bottom_side_pos')
        if done:
            return

        # Step 5: Pull the bottom drawer open
        print("[Task] Pulling the bottom drawer open.")
        obs, reward, done = pull(env, 'gripper', 'bottom_drawer')
        if done:
            return

        # Step 6: Move to the plate's position
        print("[Task] Moving to the plate position.")
        obs, reward, done = move(env, gripper_pos, plate_pos)
        if done:
            return

        # Step 7: Drop the tomato onto the plate
        print("[Task] Dropping the tomato onto the plate.")
        obs, reward, done = place(env, 'tomato', plate_pos)
        if done:
            return

        print("[Task] Completed the goal!")        
    finally:
        # Always ensure the environment is properly shut down
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()