def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Identify positions of the interested objects
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        plate_pos = positions['plate']
        drawer_pos = positions['drawer']

        # Step 1: Move to the first tomato
        print("[Task] Moving to tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, 'init_position', tomato1_pos)
        if done:
            print("[Task] Task ended after moving to tomato1!")
            return

        # Step 2: Pick the first tomato
        print("[Task] Picking tomato1")
        obs, reward, done = pick(env, 'tomato1', 'drawer')
        if done:
            print("[Task] Task ended after picking tomato1!")
            return

        # Step 3: Move to the drawer
        print("[Task] Moving to the drawer at:", drawer_pos)
        obs, reward, done = move(env, 'drawer', drawer_pos)
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return

        # Step 4: Open the drawer
        print("[Task] Opening the drawer")
        obs, reward, done = pull(env, 'drawer', 0.1)  # Adjust parameters as necessary
        if done:
            print("[Task] Task ended after opening the drawer!")
            return

        # Step 5: Drop the first tomato into the drawer
        print("[Task] Placing tomato1 into the drawer")
        obs, reward, done = place(env, 'tomato1', drawer_pos)
        if done:
            print("[Task] Task ended after placing tomato1!")
            return

        # Step 6: Move to the second tomato
        print("[Task] Moving to tomato2 at:", tomato2_pos)
        obs, reward, done = move(env, 'init_position', tomato2_pos)
        if done:
            print("[Task] Task ended after moving to tomato2!")
            return

        # Step 7: Pick the second tomato
        print("[Task] Picking tomato2")
        obs, reward, done = pick(env, 'tomato2', 'drawer')
        if done:
            print("[Task] Task ended after picking tomato2!")
            return

        # Step 8: Move back to the drawer
        print("[Task] Moving back to the drawer")
        obs, reward, done = move(env, 'drawer', drawer_pos)
        if done:
            print("[Task] Task ended after returning to the drawer!")
            return

        # Step 9: Drop the second tomato into the drawer
        print("[Task] Placing tomato2 into the drawer")
        obs, reward, done = place(env, 'tomato2', drawer_pos)
        if done:
            print("[Task] Task ended after placing tomato2!")
            return

        # Step 10: Move to the plate
        print("[Task] Moving to the plate at:", plate_pos)
        obs, reward, done = move(env, 'drawer', plate_pos)
        if done:
            print("[Task] Task ended after moving to the plate!")
            return
        
        # Final Task: Ensure both tomatoes are now in the plate
        print("[Task] Saved both tomatoes on the plate.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()