def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object list as mentioned ('tomato1', 'tomato2', 'plate', but not a drawer)
        drawer_position = positions.get('drawer_position', None)  # Obtaining the drawer's position
        plate_position = positions['plate']
        tomatoes = [positions['tomato1'], positions['tomato2']]

        # Step 1: Move to the drawer
        print("[Task] Moving to the drawer.")
        obs, reward, done = move(env, task, from_loc=obs.robot_loc, to_loc=drawer_position)
        if done:
            print("[Task] Task ended while moving to the drawer!")
            return

        # Step 2: Open the drawer fully
        print("[Task] Attempting to open the drawer.")
        obs, reward, done = pull(env, task, pull_distance=1.0, pull_axis='x')  # Assuming a predefined pull function is available
        if done:
            print("[Task] Task ended while pulling the drawer!")
            return

        # Step 3: Pick up tomatoes from the opened drawer
        for tomato in tomatoes:
            print(f"[Task] Picking up {tomato}.")
            obs, reward, done = pick(env, task, obj=tomato, loc=drawer_position)
            if done:
                print("[Task] Task ended while picking up tomatoes!")
                return
        
            print(f"[Task] Placing {tomato} on the plate.")
            obs, reward, done = place(env, task, obj=tomato, loc=plate_position)
            if done:
                print("[Task] Task ended while placing tomatoes on the plate!")
                return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()