def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions
        bottom_anchor_pos = positions['bottom_anchor_pos']
        bottom_joint_pos = positions['bottom_joint_pos']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        plate_pos = positions['plate']

        # Step 1: Move to bottom anchor position
        print("[Task] Moving to bottom anchor position at:", bottom_anchor_pos)
        task.step = move(env, 'robot', obs.robot_position, bottom_anchor_pos)

        # Step 2: Pick the drawer at the anchor position
        print("[Task] Picking the drawer at bottom anchor position")
        task.step = pick(env, 'drawer', bottom_anchor_pos)
        
        # Step 3: Open the drawer
        print("[Task] Opening the drawer")
        task.step = pull(env, 'drawer', obs.robot_position)

        # Step 4: Pick tomatoes from the drawer
        print("[Task] Picking tomato1 at:", tomato1_pos)
        task.step = pick(env, 'tomato1', bottom_joint_pos)

        print("[Task] Picking tomato2 at:", tomato2_pos)
        task.step = pick(env, 'tomato2', bottom_joint_pos)

        # Step 5: Move to the plate position to place the tomatoes
        print("[Task] Moving to plate position at:", plate_pos)
        task.step = move(env, 'robot', obs.robot_position, plate_pos)

        # Step 6: Place the tomatoes on the plate
        print("[Task] Placing tomato1 on the plate")
        task.step = place(env, 'tomato1', plate_pos)

        print("[Task] Placing tomato2 on the plate")
        task.step = place(env, 'tomato2', plate_pos)

        print("[Task] Task completed successfully.")

    except Exception as e:
        print(f"An error occurred: {e}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()