def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Based on the feedback, we'll reference the correct positions.
        # Assuming some objects are declared in positions, namely:
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        rubbish_pos = positions['rubbish']
        table_pos = positions['table']
        plate_pos = positions['plate']
        drawer_bottom_anchor_pos = positions['bottom_anchor_pos']
        drawer_bottom_side_pos = positions['bottom_side_pos']

        # === Task Plan ===
        # 1) Move to the first drawer's anchor position
        print("[Task] Moving to bottom anchor position.")
        obs, reward, done = move(env, "nowhere_pos", drawer_bottom_anchor_pos)
        if done:
            return

        # 2) Pick up the drawer handle
        print("[Task] Picking up the drawer handle.")
        obs, reward, done = pick(env, "drawer_handle", drawer_bottom_anchor_pos)
        if done:
            return

        # 3) Pull the drawer open
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, "drawer_handle", drawer_bottom_anchor_pos)
        if done:
            return

        # 4) Move to the first tomato
        print("[Task] Moving to tomato 1 position.")
        obs, reward, done = move(env, drawer_bottom_side_pos, tomato1_pos)
        if done:
            return

        # 5) Pick the first tomato
        print("[Task] Picking tomato 1.")
        obs, reward, done = pick(env, "tomato1", tomato1_pos)
        if done:
            return

        # 6) Move to table position
        print("[Task] Moving to table position.")
        obs, reward, done = move(env, tomato1_pos, table_pos)
        if done:
            return

        # 7) Place the first tomato on the table
        print("[Task] Placing tomato 1 on the table.")
        obs, reward, done = place(env, "tomato1", table_pos)
        if done:
            return

        # 8) Move to the second tomato
        print("[Task] Moving to tomato 2 position.")
        obs, reward, done = move(env, table_pos, tomato2_pos)
        if done:
            return

        # 9) Pick the second tomato
        print("[Task] Picking tomato 2.")
        obs, reward, done = pick(env, "tomato2", tomato2_pos)
        if done:
            return

        # 10) Place the second tomato on the table
        print("[Task] Placing tomato 2 on the table.")
        obs, reward, done = place(env, "tomato2", table_pos)
        if done:
            return

        # 11) Move to the rubbish
        print("[Task] Moving to the rubbish position.")
        obs, reward, done = move(env, table_pos, rubbish_pos)
        if done:
            return

        # 12) Pick up the rubbish
        print("[Task] Picking up the rubbish.")
        obs, reward, done = pick(env, "rubbish", rubbish_pos)
        if done:
            return

        # 13) Place the rubbish in the designated area (not specifically defined but assumed)
        print("[Task] Placing rubbish in the designated area.")
        obs, reward, done = place(env, "rubbish", "designated_rubbish_area")  # Adjust as per actual area if defined
        if done:
            return

        print("[Task] Completed all actions successfully!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()