def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assume we have identified the following objects:
        drawer_pos = positions['drawer_position']  # Position of the drawer
        tomato1_pos = positions['tomato1_position']  # Position of tomato1
        tomato2_pos = positions['tomato2_position']  # Position of tomato2
        plate_pos = positions['plate_position']  # Position of the plate
        
        # Check if the drawer is at a specific position to move to
        print(f"[Task] Moving to the drawer at: {drawer_pos}")
        obs, reward, done = move(env, obs.robot, obs.robot.position, drawer_pos)
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return
        
        # Open the drawer
        print("[Task] Opening the drawer...")
        obs, reward, done = pull(env, obs.robot, obs.drawer, drawer_pos)
        if done:
            print("[Task] Task ended after opening the drawer!")
            return
        
        # Pick up the first tomato
        print("[Task] Picking up tomato 1...")
        obs, reward, done = pick(env, 'tomato1', tomato1_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking up tomato 1!")
            return
        
        # Move to the plate to place the tomato
        print(f"[Task] Moving to the plate at: {plate_pos}")
        obs, reward, done = move(env, obs.robot, obs.robot.position, plate_pos)
        if done:
            print("[Task] Task ended after moving to the plate!")
            return
        
        # Place the first tomato on the plate
        print("[Task] Placing tomato 1 on the plate...")
        obs, reward, done = place(env, 'tomato1', plate_pos)
        if done:
            print("[Task] Task ended after placing tomato 1!")
            return
        
        # Repeat for the second tomato
        print("[Task] Picking up tomato 2...")
        obs, reward, done = pick(env, 'tomato2', tomato2_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking up tomato 2!")
            return
        
        print(f"[Task] Moving to the plate at: {plate_pos}")
        obs, reward, done = move(env, obs.robot, obs.robot.position, plate_pos)
        if done:
            print("[Task] Task ended after moving to the plate!")
            return
        
        print("[Task] Placing tomato 2 on the plate...")
        obs, reward, done = place(env, 'tomato2', plate_pos)
        if done:
            print("[Task] Task ended after placing tomato 2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")